//Continuous Time Fourier Series of Sine Signal
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//periodic sine signal x(t) = sin(Wot)

t = 0:0.01:1;
T = 1;
Wo = 2*%pi/T;
xt = sin(Wo*t);
for k =0:5
  C(k+1,:) = exp(-sqrt(-1)*Wo*t.*k);
  a(k+1) = xt*C(k+1,:)'/length(t); //fourier series is done
  if(abs(a(k+1))<=0.01) 
    a(k+1)=0;
  end
end
a =a';
ak = [-a($:-1:1),a(2:$)];
disp(ak,'Continuous Time Fourier Series Coefficients are:')

//Output
// Continuous Time Fourier Series Coefficients are:
//
//
//         column 1 to 9
//
//   0.   0.   0.   0.   0.4950495i   0.  -0.4950495i   0.   0.
//
//         column 10 to 11
//
//   0.   0.
